<form method="POST" action="{{ $action }}">
    @csrf
    @if($isEdit)
        @method('PUT')
    @endif
    <div class="mb-3">
        <label class="font-weight-bold">Blok</label>
        <input type="text" name="blok" class="form-control" placeholder="Contoh: Blok D7" value="{{ old('blok', $unit->blok ?? '') }}">
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Status</label>
        <select name="status" class="form-control">
            <option value="">Pilih Status</option>
            <option value="Available" {{ old('status', $unit->status ?? '') == 'Available' ? 'selected' : '' }}>Available</option>
            <option value="Terjual" {{ old('status', $unit->status ?? '') == 'Terjual' ? 'selected' : '' }}>Terjual</option>
            <option value="Pembangunan" {{ old('status', $unit->status ?? '') == 'Pembangunan' ? 'selected' : '' }}>Pembangunan</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Luas Tanah</label>
        <div class="input-group">
            <input type="number" name="luas_tanah" class="form-control" placeholder="Misalkan, 80" value="{{ old('luas_tanah', $unit->luas_tanah ?? '') }}">
            <div class="input-group-append">
                <span class="input-group-text">m2</span>
            </div>
        </div>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Luas bangunan</label>
        <div class="input-group">
            <input type="number" name="luas_bangunan" class="form-control" placeholder="Misalkan, 54" value="{{ old('luas_bangunan', $unit->luas_bangunan ?? '') }}">
            <div class="input-group-append">
                <span class="input-group-text">m2</span>
            </div>
        </div>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Ruangan</label>
        <div class="row">
            <div class="col-6">
                <div class="form-group d-flex align-items-center mb-2">
                    <i class="fas fa-bed mr-2"></i> Kamar Tidur
                </div>
                <div class="form-group d-flex align-items-center mb-2">
                    <i class="fas fa-bath mr-2"></i> Kamar Mandi
                </div>
                <div class="form-group d-flex align-items-center mb-2">
                    <i class="fas fa-user-friends mr-2"></i> Kamar Pembantu
                </div>
            </div>
            <div class="col-6">
                <div style="width: 30%;" class="input-group mb-2">
                    <button type="button" class="btn btn-light" onclick="decrement('kamar_tidur')">-</button>
                    <input type="number" name="kamar_tidur" id="kamar_tidur" class="form-control text-center" value="{{ old('kamar_tidur', $unit->kamar_tidur ?? 1) }}" min="0">
                    <button type="button" class="btn btn-light" onclick="increment('kamar_tidur')">+</button>
                </div>
                <div style="width: 30%;" class="input-group mb-2">
                    <button type="button" class="btn btn-light" onclick="decrement('kamar_mandi')">-</button>
                    <input type="number" name="kamar_mandi" id="kamar_mandi" class="form-control text-center" value="{{ old('kamar_mandi', $unit->kamar_mandi ?? 1) }}" min="0">
                    <button type="button" class="btn btn-light" onclick="increment('kamar_mandi')">+</button>
                </div>
                <div style="width: 30%;" class="input-group mb-2">
                    <button type="button" class="btn btn-light" onclick="decrement('kamar_pembantu')">-</button>
                    <input type="number" name="kamar_pembantu" id="kamar_pembantu" class="form-control text-center" value="{{ old('kamar_pembantu', $unit->kamar_pembantu ?? 0) }}" min="0">
                    <button type="button" class="btn btn-light" onclick="increment('kamar_pembantu')">+</button>
                </div>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-6">
                <span class="text-muted small">Garasi</span>
                <div class="form-group d-flex align-items-center mb-2">
                    <i class="fas fa-warehouse ml-2 mr-2"></i> Carport / Garasi
                    <span class="text-muted small ml-2">(gunakan satuan \"Mobil\", contoh: 3 Mobil)</span>
                </div>

                <span class="text-muted small">Dapur</span>
                <div class="form-group d-flex align-items-center mb-2">
                    <i class="fas fa-utensils ml-2 mr-2"></i> Dapur
                </div>
            </div>
            <div class="col-6">
                <span class="text-muted small" style="visibility: hidden;">.</span>
                <div style="width: 30%;" class="input-group mb-2">
                    <button type="button" class="btn btn-light" onclick="decrement('carport')">-</button>
                    <input type="number" name="carport" id="carport" class="form-control text-center" value="{{ old('carport', $unit->carport ?? 1) }}" min="0">
                    <button type="button" class="btn btn-light" onclick="increment('carport')">+</button>
                </div>
                <span class="text-muted small" style="visibility: hidden;">.</span>
                <div style="width: 30%;" class="input-group mb-2">
                    <button type="button" class="btn btn-light" onclick="decrement('dapur')">-</button>
                    <input type="number" name="dapur" id="dapur" class="form-control text-center" value="{{ old('dapur', $unit->dapur ?? 1) }}" min="0">
                    <button type="button" class="btn btn-light" onclick="increment('dapur')">+</button>
                </div>
            </div>
        </div>
    </div>
    <div class="mb-3">
        <label class="font-weight-bold">Daya Listrik</label>
        <select name="daya_listrik" class="form-control">
            <option value="">Pilih Daya Listrik</option>
            <option value="900" {{ old('daya_listrik', $unit->daya_listrik ?? '') == '900' ? 'selected' : '' }}>900 VA</option>
            <option value="1300" {{ old('daya_listrik', $unit->daya_listrik ?? '') == '1300' ? 'selected' : '' }}>1300 VA</option>
            <option value="2200" {{ old('daya_listrik', $unit->daya_listrik ?? '') == '2200' ? 'selected' : '' }}>2200 VA</option>
            <option value="3500" {{ old('daya_listrik', $unit->daya_listrik ?? '') == '3500' ? 'selected' : '' }}>3500 VA</option>
        </select>
    </div>
    <div class="text-right">
        <button type="submit" class="btn btn-warning">SIMPAN</button>
    </div>
</form>
<script>
function increment(id) {
    var input = document.getElementById(id);
    input.value = parseInt(input.value) + 1;
}
function decrement(id) {
    var input = document.getElementById(id);
    if (parseInt(input.value) > 0) input.value = parseInt(input.value) - 1;
}
</script> 