<?php

namespace App\Http\Controllers;

use App\Models\SimulasiKpr;
use Illuminate\Http\Request;

class SimulasiKprController extends Controller
{
    public function index()
    {
        $simulasis = SimulasiKpr::all();
        return view('admin.simulasikpr.index', compact('simulasis'));
    }

    public function create()
    {
        return view('admin.simulasikpr.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'bank' => 'required|string|max:255',
            'jenis_program' => 'nullable|array',
            'jenis_program.*' => 'nullable|string',
            'suku_bunga' => 'nullable|string|max:255',
            'tempo_angsuran' => 'nullable|array',
            'tempo_angsuran.*' => 'nullable|string',
        ]);
        $data['jenis_program'] = array_filter($data['jenis_program'] ?? []);
        $data['tempo_angsuran'] = array_filter($data['tempo_angsuran'] ?? []);
        SimulasiKpr::create($data);
        return redirect()->route('admin.simulasikpr.index')->with('success', 'Data simulasi KPR berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $simulasi = SimulasiKpr::findOrFail($id);
        return view('admin.simulasikpr.edit', compact('simulasi'));
    }

    public function update(Request $request, $id)
    {
        $simulasi = SimulasiKpr::findOrFail($id);
        $data = $request->validate([
            'bank' => 'required|string|max:255',
            'jenis_program' => 'nullable|array',
            'jenis_program.*' => 'nullable|string',
            'suku_bunga' => 'nullable|string|max:255',
            'tempo_angsuran' => 'nullable|array',
            'tempo_angsuran.*' => 'nullable|string',
        ]);
        $data['jenis_program'] = array_filter($data['jenis_program'] ?? []);
        $data['tempo_angsuran'] = array_filter($data['tempo_angsuran'] ?? []);
        $simulasi->update($data);
        return redirect()->route('admin.simulasikpr.index')->with('success', 'Data simulasi KPR berhasil diupdate.');
    }

    public function destroy($id)
    {
        $simulasi = SimulasiKpr::findOrFail($id);
        $simulasi->delete();
        return redirect()->route('admin.simulasikpr.index')->with('success', 'Data simulasi KPR berhasil dihapus.');
    }

    public function frontend()
    {
        return view('frontend.simulasi-kpr');
    }
} 