<x-admin>
@section('title', 'Kontak WA')
<div class="container">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="font-weight-bold">Kontak WA</h3>
                <a href="{{ route('admin.kontakwa.create') }}" class="btn btn-outline-secondary">Tambah Nomor WA</a>
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Nomor WA</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($kontaks as $kontak)
                    <tr>
                        <td>{{ $kontak->nomor }}</td>
                        <td><a href="{{ route('admin.kontakwa.edit', $kontak->id) }}" class="btn btn-primary btn-sm">Lihat/edit</a></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="2" class="text-center text-muted">Belum ada nomor WA yang terdaftar.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
</x-admin> 