<?php

namespace App\Http\Controllers;

use App\Models\Karir;
use Illuminate\Http\Request;

class KarirController extends Controller
{
    public function index()
    {
        $karirs = Karir::all();
        return view('admin.karir.index', compact('karirs'));
    }

    public function create()
    {
        return view('admin.karir.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'jabatan' => 'required|string|max:255',
            'status' => 'required|string',
            'tentang' => 'nullable|string',
            'insentif' => 'nullable|string',
            'syarat' => 'nullable|string',
            'cara_mendaftar' => 'nullable|string',
        ]);
        Karir::create($data);
        return redirect()->route('admin.karir.index')->with('success', 'Lowongan berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $karir = Karir::findOrFail($id);
        return view('admin.karir.edit', compact('karir'));
    }

    public function update(Request $request, $id)
    {
        $karir = Karir::findOrFail($id);
        $data = $request->validate([
            'jabatan' => 'required|string|max:255',
            'status' => 'required|string',
            'tentang' => 'nullable|string',
            'insentif' => 'nullable|string',
            'syarat' => 'nullable|string',
            'cara_mendaftar' => 'nullable|string',
        ]);
        $karir->update($data);
        return redirect()->route('admin.karir.index')->with('success', 'Lowongan berhasil diupdate.');
    }

    public function show($id)
    {
        $karir = Karir::findOrFail($id);
        return view('admin.karir.show', compact('karir'));
    }

    public function destroy($id)
    {
        $karir = Karir::findOrFail($id);
        $karir->delete();
        return redirect()->route('admin.karir.index')->with('success', 'Lowongan berhasil dihapus.');
    }
} 